(defproto main-window-proto '() () window-proto)


(defmeth main-window-proto :loc-size (&optional (list nil set))
"Message args: (&optional list)
 Sets or retrieves the location and size of the main window. Does not change the location or size."
  (unless (send self :has-slot 'loc-size) 
          (send self :add-slot 'loc-size '(30 30 500 300)))
  (if set (setf (slot-value 'loc-size) list))
  (slot-value 'loc-size))

(defmeth main-window-proto :isnew (&optional (size '(500 300)) (location '(30 30)))
  (send self :loc-size (combine location size))
  (apply #'mainwindow (combine location size))
  (send self :max-listener)
  (format t "~a" *vista-copyright*))

(defmeth main-window-proto :max-listener ()
  (apply #'listener (combine 0 0 (- (select (mainwindow) '(2 3)) '( 0 18)))))

(defmeth main-window-proto :size (&optional h w)
  ;(send self :size h w)
  (cond
    ((and h (not w)) (error "both height and width must be specified"))
    ((and h w) (apply #'mainwindow (combine (select (mainwindow) '(0 1)) h w))))
  (send self :max-listener)
  (select (mainwindow) '(2 3)))


(defmeth main-window-proto :location (&optional x y)
  (cond
    ((and x (not y)) (error "both x and y must be specified"))
    ((and x y) (apply #'mainwindow (combine x y (select (mainwindow) '(2 3))))))
  (send self :loc-size (mainwindow))
  (select (mainwindow) '(0 1)))
  
  
(defmeth main-window-proto :hide-listener ()
  (apply #'listener (combine (screen-size) (select (listener) '(2 3)))))

(defmeth main-window-proto :hide-window ()
  (send self :loc-size (mainwindow))
  (mainwindow 2000 2000 1 1))

(defmeth main-window-proto :show-window ()
  (apply #'mainwindow (send self :loc-size)))

(defmeth main-window-proto :show-listener ()
  (send self :show-window)
  (send self :max-listener))

(defun main-window ()
  (send main-window-proto :new))

